using log4net;
using Microsoft.Azure.WebJobs;
using System.Threading.Tasks;
using VA.PPMS.IWS.ProviderService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class ProviderPayloadQueueTrigger
    {
        [FunctionName("ProviderPayloadQueueTrigger")]
        public static async Task Run([QueueTrigger("%ProviderPayloadQueue%", Connection = "AzureWebJobsStorage")]string dasMessage, 
            [Inject]IProviderService providerService,
            [Inject] ILog logger)
        {
            try
            {
                logger.Info($"Start ProviderPayloadQueueTrigger function processed function processed: {dasMessage}");

                await providerService.ProcessProviderPayload(dasMessage);

                logger.Info($"End ProviderPayloadQueueTrigger function processed function processed: {dasMessage}");
            }
            catch (System.Exception ex)
            {
                logger.Error($"ERROR ProviderPayloadQueueTrigger: {ex.Message}");
            }
        }
    }
}